
Public Class Form1
    Inherits System.Windows.Forms.Form

    Dim BytesWritten As Integer
    Dim TempStringData As String
    Dim BytesRead As Integer
    Dim logging As Integer
    Dim i As Single
    Dim x As Integer
    Dim y As Integer
    Dim newvalue As Single
    Dim oldvalue As Single
    Dim redpen As New Pen(Color.Red)
    Dim yellowpen As New Pen(Color.Yellow)
    Dim orangepen As New Pen(Color.Orange)
    Dim bluepen As New Pen(Color.Blue)
    Dim lightbluepen As New Pen(Color.LightBlue)
    Dim greenpen As New Pen(Color.Green)
    Dim blackpen As New Pen(Color.Black)
    Dim bm As New Bitmap(240, 201)
    Dim gr As Graphics = Graphics.FromImage(bm)
    Dim bm2 As New Bitmap(240, 201)
    Dim gr2 As Graphics = Graphics.FromImage(bm2)

    Dim octanenewvalue As Single = 0
    Dim octaneoldvalue As Single = -9999
    Dim tpsnewvalue As Single = 0
    Dim tpsoldvalue As Single = -9999
    Dim knocknewvalue As Single = 0
    Dim knockoldvalue As Single = -9999
    Dim mapnewvalue As Single = 0
    Dim mapoldvalue As Single = -9999
    Dim iatnewvalue As Single = 0
    Dim iatoldvalue As Single = -9999
    Dim matnewvalue As Single = 0
    Dim matoldvalue As Single = -9999
    Dim rpmnewvalue As Single = 0
    Dim rpmoldvalue As Single = -9999
    Dim Logger As System.IO.TextWriter

    Private Sub Button1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button1.Click
        If Button1.Text = "Start" Then

            FT_Status = FT_OpenByIndex(0, FT_Handle)
            If FT_Status <> FT_OK Then
                MsgBox("Unable to open port")
                Exit Sub
            End If
            Button1.Text = "Stop"

            FT_Status = FT_SetTimeouts(FT_Handle, 500, 500)
            FT_Status = FT_SetLatencyTimer(FT_Handle, 1)
            FT_Status = FT_SetBaudRate(FT_Handle, 15625)
            FT_Status = FT_SetBreakOn(FT_Handle)
            Sleep(1800)
            FT_Status = FT_SetBreakOff(FT_Handle)
            Sleep(400)

            ' Get number of bytes waiting to be read
            FT_Status = FT_GetQueueStatus(FT_Handle, FT_RxQ_Bytes)
            If FT_Status <> FT_OK Then
                Exit Sub
            End If
            ' Read number of bytes waiting
            ' Allocate string to recieve data
            TempStringData = Space(FT_RxQ_Bytes + 1)
            FT_Status = FT_Read_String(FT_Handle, TempStringData, FT_RxQ_Bytes, BytesRead)
            If FT_Status <> FT_OK Then
                Exit Sub
            End If

            logging = True
            StartLogger()
            Timer3.Enabled = True

        ElseIf Button1.Text = "Stop" Then
            Button1.Text = "Start"
            Close_USB_Device()
            logging = False
            Closelog()
        End If
    End Sub




    Private Sub Timer3_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer3.Tick
        Dim Injpw As Single
        Dim outp As String
        outp = Strings.Right("00" & DateTime.Now.Hour, 2) _
                & Strings.Right("00" & DateTime.Now.Minute, 2) _
                & Strings.Right("00" & DateTime.Now.Second, 2) & ","

        Timer3.Enabled = False

        i = send(&H27) * 100 / 255
        i = Math.Round(i, 1)
        If logging = True Then
            If i < 100 Then
                Octane.BackColor = Color.Red
            Else
                Octane.BackColor = Color.White
            End If
            Octane.Text = i.ToString
            outp = outp & i.ToString & ","
            octanenewvalue = i
        End If

        i = send(&H26)
        i = Math.Round(i, 0)
        If logging = True Then
            Knock.Text = i.ToString
            outp = outp & i.ToString & ","
            knocknewvalue = i
        End If

        i = send(&H6) - 20
        i = Math.Round(i, 0)
        If logging = True Then
            Timing.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H38) * 1.334
        i = Math.Round(i, 0)
        If logging = True Then
            MAP.Text = i.ToString
            outp = outp & i.ToString & ","
            mapnewvalue = i
        End If

        i = send(&H15) / 2
        i = Math.Round(i, 1)
        If logging = True Then
            Baro.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H3A)
        i = Math.Round(i, 0)
        If logging = True Then
            Atconvert()
            IAT.Text = i.ToString
            outp = outp & i.ToString & ","
            iatnewvalue = i
            If iatnewvalue > 100 Then iatnewvalue = 100
            If iatnewvalue < 0 Then iatnewvalue = 0
        End If

        i = send(&HBD)
        i = Math.Round(i, 0)
        If logging = True Then
            Atconvert()
            MAT.Text = i.ToString
            outp = outp & i.ToString & ","
            matnewvalue = i
            If matnewvalue > 100 Then matnewvalue = 100
            If matnewvalue < 0 Then matnewvalue = 0
        End If

        i = send(&H7)
        i = Math.Round(i, 0)
        If logging = True Then
            Ctconvert()
            Coolant.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H34)
        i = Math.Round(i, 0)
        If logging = True Then
            Mapsw.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H29) * 0.256
        Injpw = i
        i = Math.Round(i, 1)
        If logging = True Then
            IPW.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H17) * 100 / 255
        i = Math.Round(i, 0)
        If logging = True Then
            TPS.Text = i.ToString
            outp = outp & i.ToString & ","
            tpsnewvalue = i
        End If

        i = send(&H21) * 31.25
        i = Math.Round(i, 0)
        rpmnewvalue = i
        If logging = True Then
            RPM.Text = i.ToString
            outp = outp & i.ToString & ","
            If i <> 0 Then
                i = i * Injpw / 1200
                i = Math.Round(i, 1)
                IDC.Text = i
                outp = outp & i.ToString & ","
            Else
                IDC.Text = 0
                outp = outp & i.ToString & ","
            End If
        End If

        i = send(&H1A) * 6.29
        i = Math.Round(i, 0)
        If logging = True Then
            Airflow.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H1C) * 5 / 8
        i = Math.Round(i, 0)
        If logging = True Then
            Engload.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H14) * 0.0733
        i = Math.Round(i, 1)
        If logging = True Then
            Battery.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H32)
        i = 14.7 * 128 / i
        i = Math.Round(i, 1)
        If logging = True Then
            AFRmap.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        i = send(&H13) * 0.02
        i = Math.Round(i, 2)
        If logging = True Then
            Oxygen.Text = i.ToString
            outp = outp & i.ToString & ","
        End If

        If logging = True Then
            Logger.WriteLine(outp)
        End If

        gr.DrawImage(PictureBox1.Image, -1, 0)

        gr.DrawLine(blackpen, 239, 0, 239, 200)

        newvalue = 2 * (100 - octanenewvalue)
        oldvalue = octaneoldvalue
        octaneoldvalue = newvalue
        If oldvalue = -9999 Then oldvalue = newvalue
        gr.DrawLine(greenpen, PictureBox1.Width - 2, oldvalue, PictureBox1.Width - 1, newvalue)

        newvalue = 2 * (100 - tpsnewvalue)
        oldvalue = tpsoldvalue
        tpsoldvalue = newvalue
        If oldvalue = -9999 Then oldvalue = newvalue
        gr.DrawLine(orangepen, PictureBox1.Width - 2, oldvalue, PictureBox1.Width - 1, newvalue)

        newvalue = 5 * (40 - knocknewvalue)
        oldvalue = knockoldvalue
        knockoldvalue = newvalue
        If oldvalue = -9999 Then oldvalue = newvalue
        gr.DrawLine(redpen, PictureBox1.Width - 2, oldvalue, PictureBox1.Width - 1, newvalue)

        If tpsnewvalue = 100 Then
            bm2.SetPixel(rpmnewvalue / 40, newvalue, Color.Red)
        ElseIf tpsnewvalue > 90 Then
            bm2.SetPixel(rpmnewvalue / 40, newvalue, Color.Blue)
        Else
            bm2.SetPixel(rpmnewvalue / 40, newvalue, Color.Green)
        End If

        newvalue = 2 * (100 - iatnewvalue)
        oldvalue = iatoldvalue
        iatoldvalue = newvalue
        If oldvalue = -9999 Then oldvalue = newvalue
        gr.DrawLine(lightbluepen, PictureBox1.Width - 2, oldvalue, PictureBox1.Width - 1, newvalue)

        newvalue = 2 * (100 - matnewvalue)
        oldvalue = matoldvalue
        matoldvalue = newvalue
        If oldvalue = -9999 Then oldvalue = newvalue
        gr.DrawLine(bluepen, PictureBox1.Width - 2, oldvalue, PictureBox1.Width - 1, newvalue)

        newvalue = 2 / 3 * (300 - mapnewvalue)
        oldvalue = mapoldvalue
        mapoldvalue = newvalue
        If oldvalue = -9999 Then oldvalue = newvalue
        gr.DrawLine(yellowpen, PictureBox1.Width - 2, oldvalue, PictureBox1.Width - 1, newvalue)

        PictureBox1.Image = bm
        PictureBox2.Image = bm2

        If logging = True Then Timer3.Enabled = True

    End Sub

    Private Function send(ByVal request As Byte)
        Dim i As Single
        Dim j As Integer

        If logging = True Then
            FT_Out_Buffer(0) = request
            Write_Data_Bytes(1)
            If FT_Status <> FT_OK Then
                Button1.Text = "Start"
                Close_USB_Device()
                logging = False
                Closelog()
                Return 0
                Exit Function
            End If
            Read_Data_Bytes(2)
            If FT_Status <> FT_OK Then
                Button1.Text = "Start"
                Close_USB_Device()
                logging = False
                Closelog()
                Return 0
                Exit Function
            End If
            j = FT_In_Buffer(1)
        Else
            j = 0
        End If
        i = j
        Return i
    End Function

    Private Sub Atconvert()
        Dim a As Integer
        Dim b As Integer
        Dim _data() As Byte
        _data = New Byte() {&HF4, &HB0, &H91, &H80, &H74, &H6A, &H62, &H5A, &H53, &H4C, &H45, &H3E, &H35, &H2B, &H1D, &H1, &H1}
        a = _data(i \ 16)
        b = _data((i \ 16) + 1)
        i = a + (((i Mod 16) * (b - a)) \ 16) - 60
    End Sub
    Private Sub Ctconvert()
        Dim a As Integer
        Dim b As Integer
        Dim _data() As Byte
        _data = New Byte() {&HEE, &HBE, &HA0, &H90, &H84, &H7B, &H73, &H6C, &H65, &H5F, &H58, &H51, &H49, &H40, &H33, &H15, &H15}
        a = _data(i \ 16)
        b = _data((i \ 16) + 1)
        i = a + (((i Mod 16) * (b - a)) \ 16) - 80
    End Sub

    Private Sub OpenLog(ByVal fName As String)
        Logger = New System.IO.StreamWriter(fName)
        Logger.WriteLine("Time,Octane,Knock,Timing,MAP(kPA),Baro(kPa),IAT(C),MAT(C),Coolant(C),Map #,IPW(ms),TPS(%),RPM,IDC(%),Airflow(Hz),Load(159),Battery(V),AFRMAP(lambda),Oxygen(V),")
    End Sub
    Private Sub Closelog()
        Logger.Close()
    End Sub

    Private Sub StartLogger()
        OpenLog(loggingdirectory.Text _
                & DateTime.Now.Year & "-" _
                & Strings.Right("00" & DateTime.Now.Month, 2) & "-" _
                & Strings.Right("00" & DateTime.Now.Day, 2) & "-" _
                & Strings.Right("00" & DateTime.Now.Hour, 2) _
                & Strings.Right("00" & DateTime.Now.Minute, 2) _
                & Strings.Right("00" & DateTime.Now.Second, 2) & ".csv")
    End Sub

    Private Sub Button2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button2.Click
        i = send(&HE0)
        i = send(&HFF)
        i = send(&HFF)
        i = send(&H80)
        i = send(&HB)
        i = send(&HE2)
        i = send(&H0)
    End Sub

    Private Sub Button3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button3.Click
        i = send(&HE0)
        i = send(&HFF)
        i = send(&HFF)
        i = send(&H80)
        i = send(&HB)
        i = send(&HE2)
        i = send(&H1)
    End Sub

    Private Sub Button4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button4.Click
        i = send(&HE3)
    End Sub


    Dim fuel As New DataSet
    Dim ignition As New DataSet

    Const FuelLoadAxisValues = "10,20,30,40,50,60,70,80,90,100,120,140,160,180,200,220,240,260,280,300"
    Const FuelRPMAxisValues = "500,1000,1500,2000,2500,3000,3500,4000,4500,5000,5500,6000,6500,7000,7500"
    Const IgnLoadAxisValues = "0,10,20,30,40,50,60,70,80,90,100,120,140,160,180,200,220,240,260,280,300"
    Const IgnRPMAxisValues = "0,500,750,1000,1250,1500,2000,2500,3000,3500,4000,4500,5000,5500,6000,6500,7000,7500,11000"


    Private Sub gridfuel(ByVal x As Integer, ByVal y As Integer, ByVal d As Integer)
        While fuel.Tables(0).Rows.Count <= y
            fuel.Tables(0).Rows.Add()
        End While
        fuel.Tables(0).Rows(y).Item(x) = d.ToString
    End Sub
    Private Sub gridign(ByVal x As Integer, ByVal y As Integer, ByVal d As Integer)
        While ignition.Tables(0).Rows.Count <= y
            ignition.Tables(0).Rows.Add()
        End While
        ignition.Tables(0).Rows(y).Item(x) = d.ToString
    End Sub
    Private Sub MapTrace_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load
        PictureBox1.Image = bm
        PictureBox2.Image = bm2
        fuel.Tables.Add("MyFuelTable")
        ignition.Tables.Add("MyIgnTable")

        Dim i As Integer

        Dim tmp1(32)
        Dim tmp2(32)

        tmp1 = FuelRPMAxisValues.Split(",")
        tmp2 = FuelLoadAxisValues.Split(",")

        For i = 0 To 20
            fuel.Tables(0).Columns.Add(i.ToString)
        Next

        For i = 0 To 14
            gridfuel(0, i + 1, tmp1(i)) 'write the RPM axis values
        Next

        For i = 0 To 19
            gridfuel(i + 1, 0, tmp2(i)) 'write the load axis values
        Next

        Me.DataGridView1.DataSource = fuel
        Me.DataGridView1.DataMember = "MyFuelTable"

        tmp1 = IgnRPMAxisValues.Split(",")
        tmp2 = IgnLoadAxisValues.Split(",")

        For i = 0 To 21
            ignition.Tables(0).Columns.Add(i.ToString)
        Next

        For i = 0 To 18
            gridign(0, i + 1, tmp1(i)) 'write the RPM axis values
        Next

        For i = 0 To 20
            gridign(i + 1, 0, tmp2(i)) 'write the load axis values
        Next

        Me.DataGridView2.DataSource = ignition
        Me.DataGridView2.DataMember = "MyIgnTable"

    End Sub

    Private Sub Button6_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button6.Click
        i = send(&HE0) 'define 4 byte address to work with
        i = send(&HFF) '1st byte
        i = send(&HFF) '2nd byte
        i = send(&H80) '3rd byte
        i = send(&HBD) '4th byte - so FFFF80BD - the start of the RAM fuel map

        For x = 1 To 20
            For y = 1 To 15
                i = send(&HE1) 'loop through the RAM fuel map with autoinc read
                i = 14.7 * 128 / i ' convert to afr
                i = System.Math.Round(i, 1) 'round to 1 dec pl
                fuel.Tables(0).Rows(y).Item(x) = i.ToString 'write to array
            Next
        Next

    End Sub

    Private Sub Button5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button5.Click
        i = send(&HE0) 'define 4 byte address to work with
        i = send(&HFF) '1st byte
        i = send(&HFF) '2nd byte
        i = send(&H80) '3rd byte
        i = send(&HBD) '4th byte - so FFFF80BD - the start of the RAM fuel map

        For x = 1 To 20
            For y = 1 To 15
                i = send(&HE2) 'loop through the RAM fuel map with autoinc write
                i = fuel.Tables(0).Rows(y).Item(x)
                i = 128 * 14.7 / i ' convert to dec
                i = System.Math.Round(i, 0) 'round to 0 dec pl
                i = Int(i)
                i = send(i)
            Next
        Next

    End Sub



    Private Sub Button8_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button8.Click
        i = send(&HE0) 'define 4 byte address to work with
        i = send(&HFF) '1st byte
        i = send(&HFF) '2nd byte
        i = send(&H82) '3rd byte
        i = send(&H37) '4th byte - so FFFF8237 - the start of the RAM ign map

        For x = 1 To 21
            For y = 1 To 19
                i = send(&HE1) 'loop through the RAM ign map with autoinc read

                If i > 128 Then i = i - 256
                ignition.Tables(0).Rows(y).Item(x) = i.ToString 'write to array
            Next
        Next

    End Sub

    Private Sub Button7_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Button7.Click
        i = send(&HE0) 'define 4 byte address to work with
        i = send(&HFF) '1st byte
        i = send(&HFF) '2nd byte
        i = send(&H82) '3rd byte
        i = send(&H37) '4th byte - so FFFF8237 - the start of the RAM ign map

        For x = 1 To 21
            For y = 1 To 19
                i = send(&HE2) 'loop through the RAM ign map with autoinc write

                i = ignition.Tables(0).Rows(y).Item(x)
                If i < 0 Then i = i + 256
                i = send(i)
            Next
        Next
    End Sub

End Class